import de.bebagoe.matrain.stats.DataMat;

void main() {
    final int zeilen = 5, spalten = 3;
    DataMat matrix = new DataMat(zeilen, spalten);

    matrix.data[0] = new double[]{1.0, 2.0, 4.0};
    matrix.data[1] = new double[]{1.0, 2.0, 5.0};
    matrix.data[2] = new double[]{2.0, 2.0, 6.0};
    matrix.data[3] = new double[]{2.0, 1.0, 5.0};
    matrix.data[4] = new double[]{3.0, 1.0, 4.0};

    IO.println("Datenmatrix mit 5 Fällen und 3 Merkmalen:");
    matrix.show();

    for (int i = 0; i < spalten; i++) {
        NavigableMap<Double, Long> ft = matrix.frequencies(i);
        if (ft != null) {
            IO.println("\nHäufigkeiten Merkmal " + i + ":");
            IO.println("    Wert       N");
            for (Double d : ft.keySet())
                System.out.printf(" %7.2f %7d\n", d, ft.get(d));
        }
    }
}